/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.containers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.SlotItemHandler;

public abstract class AbstractPipeGui<T extends AbstractPipeContainer<?>>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/pipe.png");
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final ItemStack[] lastItems;

    public AbstractPipeGui(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.lastItems = new ItemStack[((AbstractPipeContainer)this.f_97732_).tile.modules.getSlots()];
        this.f_97726_ = 176;
        this.f_97727_ = 203;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initTabs();
    }

    public void m_181908_() {
        super.m_181908_();
        boolean changed = false;
        for (int i = 0; i < ((AbstractPipeContainer)this.f_97732_).tile.modules.getSlots(); ++i) {
            ItemStack stack = ((AbstractPipeContainer)this.f_97732_).tile.modules.getStackInSlot(i);
            if (stack == this.lastItems[i]) continue;
            this.lastItems[i] = stack;
            changed = true;
        }
        if (changed) {
            this.initTabs();
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        for (Widget widget : this.f_169369_) {
            AbstractWidget abstractWidget;
            if (!(widget instanceof AbstractWidget) || !(abstractWidget = (AbstractWidget)widget).m_198029_()) continue;
            abstractWidget.m_7428_(matrix, mouseX, mouseY);
        }
        this.m_7025_(matrix, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(matrix, this.f_169604_.getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        this.f_96547_.m_92883_(matrix, this.f_96539_.getString(), 8.0f, 38.0f, 0x404040);
        for (Tab tab : this.tabs) {
            tab.drawForeground(matrix, mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrix, this.f_97735_, this.f_97736_ + 32, 0, 0, 176, 171);
        for (Tab tab : this.tabs) {
            tab.draw(matrix);
        }
        for (Slot slot : ((AbstractPipeContainer)this.f_97732_).f_38839_) {
            if (!(slot instanceof SlotItemHandler)) continue;
            this.m_93228_(matrix, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 176, 62, 18, 18);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        for (Tab tab : this.tabs) {
            if (!tab.onClicked(x, y, button)) continue;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    private void initTabs() {
        this.tabs.clear();
        this.tabs.add(new Tab(new ItemStack((ItemLike)Registry.pipeBlock), 0, -1));
        for (int i = 0; i < ((AbstractPipeContainer)this.f_97732_).tile.modules.getSlots(); ++i) {
            IModule module;
            ItemStack stack = ((AbstractPipeContainer)this.f_97732_).tile.modules.getStackInSlot(i);
            if (stack.m_41619_() || !(module = (IModule)stack.m_41720_()).hasContainer(stack, ((AbstractPipeContainer)this.f_97732_).tile)) continue;
            this.tabs.add(new Tab(stack, this.tabs.size(), i));
        }
    }

    private class Tab {
        private final ItemStack moduleStack;
        private final int index;
        private final int x;
        private final int y;

        public Tab(ItemStack moduleStack, int tabIndex, int index) {
            this.moduleStack = moduleStack;
            this.index = index;
            this.x = AbstractPipeGui.this.f_97735_ + 5 + tabIndex * 28;
            this.y = AbstractPipeGui.this.f_97736_;
        }

        private void draw(PoseStack matrix) {
            int y = 2;
            int v = 0;
            int height = 30;
            int itemOffset = 9;
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).f_97732_).moduleIndex) {
                y = 0;
                v = 30;
                height = 32;
                itemOffset = 7;
            }
            AbstractPipeGui.this.m_93228_(matrix, this.x, this.y + y, 176, v, 28, height);
            AbstractPipeGui.this.f_96542_.m_115123_(this.moduleStack, this.x + 6, this.y + itemOffset);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        }

        private void drawForeground(PoseStack matrix, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseY < this.y || mouseX >= this.x + 28 || mouseY >= this.y + 32) {
                return;
            }
            AbstractPipeGui.this.m_96602_(matrix, this.moduleStack.m_41786_(), mouseX - AbstractPipeGui.this.f_97735_, mouseY - AbstractPipeGui.this.f_97736_);
        }

        private boolean onClicked(double mouseX, double mouseY, int button) {
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).f_97732_).moduleIndex) {
                return false;
            }
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX >= (double)(this.x + 28) || mouseY >= (double)(this.y + 32)) {
                return false;
            }
            PacketHandler.sendToServer(new PacketButton(((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).f_97732_).tile.m_58899_(), PacketButton.ButtonResult.PIPE_TAB, this.index));
            AbstractPipeGui.this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
    }
}

